//       file: ##.asm
//    project: Turrican2 plain -TDE v1.0
// asm format: Kick Assembler
// -------------------------------------
// ## replacement to load hushhush replacement loader without
// visible garbage on default BASIC screen

* = $0326 // CHROUT vector address

.word prgstart                                  // autostart via kernal CHROUT vector hook, aka "READY" trap
.word $f6ed, $f13e, $f32f, $fe66, $f4a5, $f5ed  // other kernal vectors
memcfg: .byte $00

sr_load0: // replaces drive-code based loader with standard kernal loads

lda $01 
sta memcfg // store ram/rom cfg
and #%11111000
ora #%00000111 // mem cfg to: BASIC, IO, KERNAL
sta $01//*/

lda #$08     // "hushhush" is an 8 letter name	
jsr $FFBD    // KERNAL SET FILENAME, length A, Y high address, X low address
lda #$00
ldx #$08
ldy #$01
jsr $FFBA    // KERNAL SET LOGICAL FILE PARAMS, A file number, X device, Y secondary address
lda #$00
tax
tay
jsr $FFD5    // KERNAL LOAD/VERIFY RAM FROM DEVICE, A 0 = load, X,Y load address if secondary address == 0

lda memcfg
sta $01 // restore pre load ram/rom cfg*/

rts    
sr_load_after:

fname:
.text "HUSHHUSH" // note for debug: not the same as "hushhush.prg"
                 // so copy "hushhush.prg" to "hushhush" for testing without
                 // a disk image
                  
.var brk_file = createFile("breakpoints.txt")

.macro break() 
{
  .eval brk_file.writeln("break " + toHexString(*))
}

.macro break_at(address)
{
  .eval brk_file.writeln("break " + toHexString(address))
}

.label prgstart = *
main: 
// ---- section copied verbatim from original ##.prg -------------------------------------------------------
    cld
    lda #$CA
    sta $0326
    lda #$F1
    sta $0327 // original CHROUT vector restored
        
    lda #$00
    sta $D120 // BORDER COLOR BLACK	(VIC registers at $D000 repeat every 64 bytes until $D3FF)
    sta $D221 // BACKGROUND COLOR BLACK
    sta $D1D1 // SCREEN CONTROL REGISTER (same as $D011, because of repeated registers at 00,40,80,C0 (D1-C0==11)
              // v-scroll 0, screen height = 24 rows, screen off, extended bg mode off, raster interrupt line 0
    sta $D015 // disable sprites
    sta $9D   // suppress error/kernal messages
// ---- end of section copied verbatim from original ##.prg ------------------------------------------------    

    ldy #(to_here-from_here)
    lda #<from_here
    sta $02
    lda #>from_here
    sta $03
    lda #<to_800
    sta $04
    lda #>to_800
    sta $05
reloc:
    lda ($02),Y
    sta ($04),Y
    dey    
    bpl reloc
    jmp $0800

from_here: // can't execute here directly because hushhush will be loaded over
           // this location which will butcher the code at the return address
    sei
    ldx #<fname 
    ldy #>fname
    jsr sr_load0
    jmp ($0326) // will hold start of main inside hushhush program
to_here:
    brk
.label to_800 = $0800
